#!/usr/bin/env python
import colorsys
import paint

def spectrum(num):
    step = 1.0 / num
    colors = []
    h = 0.0
    for i in range(num):
        r, b, g = colorsys.hsv_to_rgb(h, 1.0, 1.0)
        colors.append(paint.rgb(int(0xff * r), int(0xff * g), int(0xff * b)))
        h = h + step
    return colors

def pie_plot(image, nums):
    total = 0.0
    for num in nums:
        total = total + num
    angle = 0.0
    colors = spectrum(len(nums))
    for color, num in map(None, colors, nums):
        sweep = (num / total) * 360.0
        arc = paint.arc_pie(25, 25, image.width - 25, image.height - 25,
                            angle, sweep)
        image.stroke(arc, paint.rgb(0,0,0), 1)
        image.fill(arc, color)
        angle = angle + sweep

image = paint.image(200, 200)
pie_plot(image, (79, 109, 50, 32, 54, 21, 77))
image.write_png("pie.png")
