#!/usr/bin/env python
import math
import whrandom
import colorsys
import paint

rand = whrandom.whrandom().random

def spectrum(num):
    step = 1.0 / num
    colors = []
    h = 0.0
    for i in range(num):
        r, b, g = colorsys.hsv_to_rgb(h, 1.0, 1.0)
        colors.append(paint.rgb(int(0xff * r), int(0xff * g), int(0xff * b)))
        h = h + step
    return colors

def randstar(radius, n):
    path = []
    for i in range(n):
        r = rand() * radius
        th = i * 2 * math.pi / n
        x = r * math.cos(th)
        y = r * math.sin(th)
        if i == 0:
            start_x = x
            start_y = y
            path.append((paint.MOVETO, x, y))
        else:
            path.append((paint.LINETO, x, y))
    path.append((paint.LINETO, start_x, start_y))
    return paint.make_path(path)

def line(x1, y1, x2, y2):
    path = []
    path.append((paint.MOVETO, x1, y1))
    path.append((paint.LINETO, x2, y2))
    return paint.make_path(path)

radius = 150
rotate = paint.affine()
rotate.rotate(15)
translate = paint.affine()
translate.translate(200, 200)

arial = '/dos/windows/fonts/arial.ttf'
arialn = '/dos/windows/fonts/arialn.ttf'
arialb = '/dos/windows/fonts/arialbd.ttf'
times = '/dos/windows/fonts/times.ttf'

image = paint.image(320, 320)

def stars():
    for color in spectrum(3):
        star = randstar(radius, 10)
        for i in range(3):
            image.stroke(star.transform(translate), color, 10)
            star = star.transform(rotate)

def woohoo():
    angle = 0
    text = 'Yay - it rotates'
    for i in range(8):
        x = y = 160
        font = paint.font(arialn, 18, angle)
        for ch, color in map(None, text, spectrum(len(text))):
            image.text(font, x, y, color, ch)
            xs, ys = font.advance(ch)
            x = x + xs
            y = y + ys
        angle = angle + 45
    image.stroke(line(0, 159.5, 320, 159.5), paint.rgb(0,0,0), 1)
    image.stroke(line(159.5, 0, 159.5, 320), paint.rgb(0,0,0), 1)
    image.stroke(line(0, 0, 320, 320), paint.rgb(0,0,0), 1)
    image.stroke(line(0, 320, 320, 0), paint.rgb(0,0,0), 1)

def lines():
    for i in range(0, 10):
        y = i * 3 + 120 + 0.5
        if i > 0:
            image.stroke(line(20, y, 100, y).dash(0, (i, 2)),
                         paint.rgb(0,0,0), 1)
        else:
            image.stroke(line(20, y, 100, y), paint.rgb(0,0,0), 1)

def text():
    x = 20.0
    y = 300.0
    size = 10
    text = 'aaaaaaaaaaaaaaaaaaaaaaa'
    for color, ch in map(None, spectrum(len(text)), text):
        font = paint.font(arial, size, 10)
        x, y = image.text(font, x, y, paint.rgb(0,0,0), ch)
        size = size + 1

woohoo()
image.write_png("draw.png")
