/******************************************************************
Copyright 2000 by Object Craft P/L, Melbourne, Australia.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of Object Craft
is not be used in advertising or publicity pertaining to
distribution of the software without specific, written prior
permission.

OBJECT CRAFT DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
EVENT SHALL OBJECT CRAFT BE LIABLE FOR ANY SPECIAL, INDIRECT OR
CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.

******************************************************************/

#ifndef __paint_h
#define __paint_h

#include <math.h>

#include <png.h>
#include <freetype.h>
#include <libart_lgpl/art_misc.h>
#include <libart_lgpl/art_affine.h>
#include <libart_lgpl/art_vpath.h>
#include <libart_lgpl/art_vpath_dash.h>
#include <libart_lgpl/art_filterlevel.h>
#include <libart_lgpl/art_svp.h>
#include <libart_lgpl/art_svp_vpath.h>
#include <libart_lgpl/art_svp_vpath_stroke.h>

#include "Python.h"

typedef struct {
    PyObject_HEAD
    double affine[6];
} AffineObj;

typedef struct {
    PyObject_HEAD
    ArtVpath *vpath;
    int vpath_len;
} PathObj;

typedef struct {
    TT_Raster_Map bit;
    TT_Raster_Map small_bit;	/* used when font-smoothing is enabled */
    int width, height;
    int x_shift, y_shift;
} Raster;

typedef struct {
    PyObject_HEAD
    TT_F26Dot6 point_size;
    int hinted;
    int dpi;
    TT_F26Dot6 ascent, descent, line_gap;
    TT_F26Dot6 offset_x, offset_y;
    TT_Face face;
    TT_Face_Properties properties;
    TT_Instance instance;
    TT_Glyph *glyphs;
    double rotate;
    int quadrant;
    TT_Matrix matrix;
} FontObj;

typedef struct {
    PyObject_HEAD
    int width;
    int height;
    art_u8 *buf;
} ImageObj;

extern PyTypeObject PathType;
extern PyTypeObject AffineType;
extern PyTypeObject FontType;
extern PyTypeObject ImageType;

void set_error(PyObject* err, char *fmt, ...);

PyObject *affine_new();

PyObject *font_draw_text(ImageObj *image, PyObject *args);
PyObject *font_new(PyObject *args);

void make_rect_vpath(ArtVpath *vpath, double x1, double y1, double x2, double y2);
PyObject *path_make_path(PyObject *args);
PyObject *path_make_arc(PyObject *args);
PyObject *path_make_arc_pie(PyObject *args);
PyObject *path_make_rect(PyObject *args);
PyObject *path_make_line(PyObject *args);

PyObject *image_new(PyObject *args);

#endif
