/******************************************************************
Copyright 2000 by Object Craft P/L, Melbourne, Australia.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of Object Craft
is not be used in advertising or publicity pertaining to
distribution of the software without specific, written prior
permission.

OBJECT CRAFT DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
EVENT SHALL OBJECT CRAFT BE LIABLE FOR ANY SPECIAL, INDIRECT OR
CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.

******************************************************************/

#include "paint.h"

void set_error(PyObject* err, char *fmt, ...)
{
    char msg[1024];
    va_list ap;

    va_start(ap, fmt);
    vsprintf(msg, fmt, ap);
    va_end(ap);
    PyErr_SetString(err, msg);
}

static char paint_rgb__doc__[] =
"rgb(r, g, b)\n"
"\n"
"Create an rgba color value with a = 0xff.";

static PyObject *paint_rgb(PyObject *module, PyObject *args)
{
    int r, g, b;

    if (!PyArg_ParseTuple(args, "iii", &r, &g, &b))
	return NULL;

    return (PyObject*)PyInt_FromLong((r << 24) + (g << 16) + (b << 8) + 0xff);
}

static char paint_rgba__doc__[] =
"rgba(r, g, b, a)\n"
"\n"
"Create an rgba color value.";

static PyObject *paint_rgba(PyObject *module, PyObject *args)
{
    int r, g, b, a;

    if (!PyArg_ParseTuple(args, "iiii", &r, &g, &b, &a))
	return NULL;

    return (PyObject*)PyInt_FromLong((r << 24) + (g << 16) + (b << 8) + a);
}

static char paint_affine__doc__[] =
"affine()\n"
"\n"
"Create an affine identity matrix.";

static PyObject *paint_affine(PyObject *module, PyObject *args)
{
    return affine_new(args);
}

static char paint_arc__doc__[] =
"arc(x1, y1, x2, y2, angle, sweep)\n"
"\n"
"Create a new Path which describes an arc.";

static PyObject *paint_arc(PyObject *module, PyObject *args)
{
    return path_make_arc(args);
}

static char paint_arc_pie__doc__[] =
"arc_pie(x1, y1, x2, y2, angle, sweep)\n"
"\n"
"Create a new Path which describes a pie style arc.";

static PyObject *paint_arc_pie(PyObject *module, PyObject *args)
{
    return path_make_arc_pie(args);
}

static char paint_rect__doc__[] =
"rect(x1, y1, x2, y2)\n"
"\n"
"Create a new Path which describes a rectangle.";

static PyObject *paint_rect(PyObject *module, PyObject *args)
{
    return path_make_rect(args);
}

static char paint_line__doc__[] =
"line(x1, y1, x2, y2)\n"
"\n"
"Create a new Path which describes a line.";

static PyObject *paint_line(PyObject *module, PyObject *args)
{
    return path_make_line(args);
}

static char paint_make_path__doc__[] =
"make_path(path)\n"
"\n"
"Create an path from a sequence of (code, x, y) tuples";

static PyObject *paint_make_path(PyObject *module, PyObject *args)
{
    return path_make_path(args);
}

static char paint_font__doc__[] =
"font(filename, size = 12, rotate = 0)\n"
"\n"
"Load the named font.";

static PyObject *paint_font(PyObject *module, PyObject *args)
{
    return font_new(args);
}

static char paint_image__doc__[] =
"image(width, height, bg_color = 0xffffffff)\n"
"\n"
"Create a new Image object of specified dimensions.";

static PyObject *paint_image(PyObject *module, PyObject *args)
{
    return image_new(args);
}

/* List of methods defined in the module */

static struct PyMethodDef paint_methods[] = {
    { "rgb", (PyCFunction)paint_rgb, METH_VARARGS, paint_rgb__doc__ },
    { "rgba", (PyCFunction)paint_rgba, METH_VARARGS, paint_rgba__doc__ },
    { "affine", (PyCFunction)paint_affine, METH_VARARGS, paint_affine__doc__ },
    { "make_path", (PyCFunction)paint_make_path, METH_VARARGS, paint_make_path__doc__ },
    { "arc", (PyCFunction)paint_arc, METH_VARARGS, paint_arc__doc__ },
    { "arc_pie", (PyCFunction)paint_arc_pie, METH_VARARGS, paint_arc_pie__doc__ },
    { "rect", (PyCFunction)paint_rect, METH_VARARGS, paint_rect__doc__ },
    { "line", (PyCFunction)paint_line, METH_VARARGS, paint_line__doc__ },
    { "font", (PyCFunction)paint_font, METH_VARARGS, paint_font__doc__ },
    { "image", (PyCFunction)paint_image, METH_VARARGS, paint_image__doc__ },
    { NULL, (PyCFunction)NULL, 0, NULL } /* sentinel */
};

/* Initialization function for the module (*must* be called initpaint) */

static char paint_module_doc[] = 
"";

void initpaint()
{
    PyObject *module;
    PyObject *dict;
    TT_Error error;

    /* Create the module and add the functions */
    module = Py_InitModule4("paint", paint_methods,
			    paint_module_doc,
			    (PyObject*)NULL, PYTHON_API_VERSION);

    /* Add some symbolic constants to the module */
    dict = PyModule_GetDict(module);
    PyDict_SetItemString(dict, "MOVETO", PyInt_FromLong(ART_MOVETO));
    PyDict_SetItemString(dict, "LINETO", PyInt_FromLong(ART_LINETO));
    PyDict_SetItemString(dict, "END", PyInt_FromLong(ART_END));

    PyDict_SetItemString(dict, "JOIN_MITER",
			 PyInt_FromLong(ART_PATH_STROKE_JOIN_MITER));
    PyDict_SetItemString(dict, "JOIN_ROUND",
			 PyInt_FromLong(ART_PATH_STROKE_JOIN_ROUND));
    PyDict_SetItemString(dict, "JOIN_BEVEL",
			 PyInt_FromLong(ART_PATH_STROKE_JOIN_BEVEL));

    PyDict_SetItemString(dict, "CAP_BUTT",
			 PyInt_FromLong(ART_PATH_STROKE_CAP_BUTT));
    PyDict_SetItemString(dict, "CAP_ROUND",
			 PyInt_FromLong(ART_PATH_STROKE_CAP_ROUND));
    PyDict_SetItemString(dict, "CAP_SQUARE",
			 PyInt_FromLong(ART_PATH_STROKE_CAP_SQUARE));

    /* Check for errors */
    if (PyErr_Occurred())
	Py_FatalError("can't initialize module paint");
}

