/******************************************************************
Copyright 2000 by Object Craft P/L, Melbourne, Australia.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of Object Craft
is not be used in advertising or publicity pertaining to
distribution of the software without specific, written prior
permission.

OBJECT CRAFT DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
EVENT SHALL OBJECT CRAFT BE LIABLE FOR ANY SPECIAL, INDIRECT OR
CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.

******************************************************************/

#include "paint.h"

static char affine_scale__doc__[] = 
"scale(x, y)\n"
"\n"
"Apply a scale transformation to the affine";

static PyObject *affine_scale(AffineObj *self, PyObject *args)
{
    double x, y;
    double affine[6];

    if (!PyArg_ParseTuple(args, "dd", &x, &y))
	return NULL;

    art_affine_scale(affine, x, y);
    art_affine_multiply(self->affine, self->affine, affine);

    Py_INCREF(Py_None);
    return Py_None;
}

static char affine_rotate__doc__[] = 
"rotate(degrees)\n"
"\n"
"Apply a rotation transformation to the affine";

static PyObject *affine_rotate(AffineObj *self, PyObject *args)
{
    double degrees;
    double affine[6];

    if (!PyArg_ParseTuple(args, "d", &degrees))
	return NULL;

    art_affine_rotate(affine, degrees);
    art_affine_multiply(self->affine, self->affine, affine);

    Py_INCREF(Py_None);
    return Py_None;
}

static char affine_shear__doc__[] = 
"shear(degrees)\n"
"\n"
"Apply a shear transformation to the affine";

static PyObject *affine_shear(AffineObj *self, PyObject *args)
{
    double degrees;
    double affine[6];

    if (!PyArg_ParseTuple(args, "d", &degrees))
	return NULL;

    art_affine_shear(affine, degrees);
    art_affine_multiply(self->affine, self->affine, affine);

    Py_INCREF(Py_None);
    return Py_None;
}

static char affine_translate__doc__[] = 
"translate(x, y)\n"
"\n"
"Apply a translation transformation to the affine";

static PyObject *affine_translate(AffineObj *self, PyObject *args)
{
    double x, y;
    double affine[6];

    if (!PyArg_ParseTuple(args, "dd", &x, &y))
	return NULL;

    art_affine_translate(affine, x, y);
    art_affine_multiply(self->affine, self->affine, affine);

    Py_INCREF(Py_None);
    return Py_None;
}

static struct PyMethodDef affine_methods[] = {
    { "scale", (PyCFunction)affine_scale, METH_VARARGS, affine_scale__doc__ },
    { "rotate", (PyCFunction)affine_rotate, METH_VARARGS, affine_rotate__doc__ },
    { "shear", (PyCFunction)affine_shear, METH_VARARGS, affine_shear__doc__ },
    { "translate", (PyCFunction)affine_translate, METH_VARARGS, affine_translate__doc__ },

    { NULL, NULL }		/* sentinel */
};

static AffineObj *new_AffineObj()
{
    AffineObj *self;

    self = PyObject_NEW(AffineObj, &AffineType);
    if (self == NULL)
	return NULL;
    art_affine_identity(self->affine);
    return self;
}

static void dealloc_AffineObj(AffineObj *self)
{
    PyMem_DEL(self);
}

static PyObject *affine_getattr(ImageObj *self, char *name)
{
    return Py_FindMethod(affine_methods, (PyObject *)self, name);
}

static char AffineType__doc__[] = 
"";

PyTypeObject AffineType = {
    PyObject_HEAD_INIT(&PyType_Type)
    0,				/*ob_size*/
    "Affine",			/*tp_name*/
    sizeof(AffineObj),		/*tp_basicsize*/
    0,				/*tp_itemsize*/
    /* methods */
    (destructor)dealloc_AffineObj, /*tp_dealloc*/
    (printfunc)0,		/*tp_print*/
    (getattrfunc)affine_getattr, /*tp_getattr*/
    (setattrfunc)0,		/*tp_setattr*/
    (cmpfunc)0,			/*tp_compare*/
    (reprfunc)0,		/*tp_repr*/
    0,				/*tp_as_number*/
    0,				/*tp_as_sequence*/
    0,				/*tp_as_mapping*/
    (hashfunc)0,		/*tp_hash*/
    (ternaryfunc)0,		/*tp_call*/
    (reprfunc)0,		/*tp_str*/

    /* Space for future expansion */
    0L, 0L, 0L, 0L,
    AffineType__doc__ /* Documentation string */
};

PyObject *affine_new(PyObject *args)
{
    if (!PyArg_ParseTuple(args, ""))
	return NULL;

    return (PyObject*)new_AffineObj();
}
